local gc = Var("GameCommand");
local st = gc:GetName();

local BamwLookup = {
  single = 216,
  versus = 334,
  double = 336,
  couple = 334,
  solo = 220
};
setmetatable(BamwLookup, { __index = function(t,k) if rawget(t,k) == nil then return 30 end end });

local BAMW = BamwLookup[st]

local BamhLookup = {
  single = 280,
  versus = 346,
  double = 352,
  couple = 346,
  solo = 334
};

setmetatable(BamhLookup, { __index = function(t,k) if rawget(t,k) == nil then return 40 end end });

local BAMH = BamhLookup[st]

local t = Def.ActorFrame {
	LoadActor( "SMMAX20preview " .. st ) .. {
		InitCommand=cmd(x,SCREEN_CENTER_X-150;y,SCREEN_CENTER_Y+40;zoomtowidth,(SCREEN_HEIGHT/3*4)/640*BAMW;zoomtoheight,SCREEN_HEIGHT/480*BAMH);
		OnCommand=cmd(finishtweening;diffusealpha,0;glow,color("1,1,1,0");linear,0.2;glow,color("1,1,1,1");linear,0.0;diffusealpha,1;linear,0.2;glow,color("1,1,1,0"));
		OffCommand=cmd(finishtweening;linear,0.5;diffusealpha,0;glow,1,1,1,0);
		GainFocusCommand=cmd(visible,true;playcommand,"On");
		LoseFocusCommand=cmd(playcommand,"Off";visible,false);
	};
	LoadActor( "SMMAX20card frame " .. st )..{
		InitCommand=cmd(x,SCREEN_CENTER_X+160;y,SCREEN_CENTER_Y+40;zoomtowidth,(SCREEN_HEIGHT/3*4)/640*286;zoomtoheight,SCREEN_HEIGHT/480*164);
		OnCommand=cmd(finishtweening;zoomtoheight,0;bounceend,0.5;zoomtoheight,SCREEN_HEIGHT/2-76);
		OffCommand=cmd(finishtweening;bouncebegin,0.5;zoomtoheight,0);
		GainFocusCommand=cmd(visible,true;playcommand,"On");
		LoseFocusCommand=cmd(playcommand,"Off";visible,false);
	};
	Def.ActorFrame {
		InitCommand=cmd(x,SCREEN_CENTER_X-260+gc:GetIndex()*80;y,84);
		LoadActor( "icon " .. st ) .. {
			OnCommand=cmd(zoomto,(SCREEN_HEIGHT/3*4)/640*64,SCREEN_HEIGHT/480*64;addx,-SCREEN_WIDTH;sleep,0.20;decelerate,0.3;addx,SCREEN_WIDTH;);
			OffCommand=cmd(bouncebegin,0.5;zoomy,0);
			EnabledCommand=cmd(diffuse,color("1,1,1,1"));
			DisabledCommand=cmd(diffuse,color(".5,.5,.5,1"));
			GainFocusCommand=cmd(glowshift;effectperiod,0.5);
			LoseFocusCommand=cmd(stopeffect);
		};
	};
};

return t;